<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Clientes_certificador extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('Clientes_certificador', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('Clientes_certificador_model');
    }

    
 public function index()
    {
        $this->sma->checkPermissions();

       $this->data['clientes_certificador'] = $this->Clientes_certificador_model->getAllConexion();


        if (!$this->data['clientes_certificador']) {
            $this->data['error'] = 'No hay certificadores disponibles.';
        }

        $bc = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('clientes_certificador')]];
        $meta = ['page_title' => lang('clientes_certificador'), 'bc' => $bc];
        $this->page_construct('clientes_certificador/index', $meta, $this->data);
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->method() === 'post') {
            $data = [
                'nombre'      => $this->input->post('nombre'),
                'descripcion' => $this->input->post('descripcion'),
                'api_path'    => $this->input->post('api_path'),
                'api_key'     => $this->input->post('api_key'),
                'activo'      => $this->input->post('activo') ? 1 : 0
            ];

            if ($this->clientes_certificador_model->addConexion($data)) {
                $this->session->set_flashdata('message', $this->lang->line('conexion_added'));
                redirect('admin/clientes_certificador');
            } else {
                $this->session->set_flashdata('error', 'Error al agregar conexión');
                redirect('admin/clientes_certificador/add');
            }
        }

        $this->load->view($this->theme . 'clientes_certificador/add', $this->data);
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        $conexion = $this->clientes_certificador_model->getConexionByID($id);
        if (!$conexion) {
            $this->session->set_flashdata('error', lang('conexion_not_found'));
            redirect('admin/clientes_certificador');
        }

        if ($this->input->method() === 'post') {
            $data = [
                'nombre'      => $this->input->post('nombre'),
                'descripcion' => $this->input->post('descripcion'),
                'api_path'    => $this->input->post('api_path'),
                'api_key'     => $this->input->post('api_key'),
                'activo'      => $this->input->post('activo') ? 1 : 0
            ];

            if ($this->clientes_certificador_model->updateConexion($id, $data)) {
                $this->session->set_flashdata('message', $this->lang->line('conexion_updated'));
                redirect('admin/clientes_certificador');
            } else {
                $this->session->set_flashdata('error', 'Error al actualizar conexión');
                redirect('admin/clientes_certificador/edit/' . $id);
            }
        }

        $this->data['conexion'] = $conexion;
        $this->load->view($this->theme . 'clientes_certificador/edit', $this->data);
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->clientes_certificador_model->deleteConexion($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('conexion_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('conexion_x_deleted_have_related_data')]);
        }
    }

  
 // Obtener todos las conexiones del certificador
  public function getConexion()
{
    $this->load->library('datatables');

    $this->datatables
        ->select('id, nombre, descripcion, api_path, api_key, activo')
        ->from('sma_clientes_certificador_conexion'); // << usar la tabla correcta

    echo $this->datatables->generate(); // devolver JSON directamente
}
    public function conexion_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->Clientes_certificador_model->deleteConexion($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('conexion_x_deleted_have_related_data'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('conexion_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_conexion_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }
}
